/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mandelbrot.view;

import ch.skybeam.mandelbrot.control.Controller;
import ch.skybeam.mandelbrot.view.ThreadConfigPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class ThreadConfiguration
extends JDialog {
    public static final String rcsHeader = "$Header: /data/cvs/diplomarbeit/JTSFraktal/src/ch/skybeam/mandelbrot/view/ThreadConfiguration.java,v 1.5 2006/11/12 12:48:33 rme Exp $";
    public static final String rcsName = "$Name:  $";
    public static final String rcsRevision = "$Revision: 1.5 $";
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JPanel configPanelHolder = null;
    private JScrollPane configScroller = null;
    private JPanel scrolingPanel = null;

    public ThreadConfiguration(Frame frame) {
        super(frame);
        this.initialize();
    }

    private void initialize() {
        this.setSize(524, 338);
        this.setTitle("Thread Configuration");
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getJContentPane());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ThreadConfiguration.this.performCancel();
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getConfigScroller(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getOkButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ThreadConfiguration.this.performOK();
                }
            });
            this.okButton.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "OK");
            this.okButton.getActionMap().put("OK", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    ThreadConfiguration.this.performOK();
                }
            });
        }
        return this.okButton;
    }

    protected void performOK() {
        Component[] componentArray = this.configPanelHolder.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            ThreadConfigPanel threadConfigPanel = (ThreadConfigPanel)componentArray[i];
            threadConfigPanel.updateThreadConfiguration();
        }
        this.dispose();
    }

    protected void performCancel() {
        this.dispose();
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ThreadConfiguration.this.performCancel();
                }
            });
            this.cancelButton.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
            this.cancelButton.getActionMap().put("Cancel", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    ThreadConfiguration.this.performCancel();
                }
            });
        }
        return this.cancelButton;
    }

    private JPanel getConfigPanelHolder() {
        if (this.configPanelHolder == null) {
            this.configPanelHolder = new JPanel();
            this.configPanelHolder.setLayout(new BoxLayout(this.getConfigPanelHolder(), 1));
            Thread[] threadArray = Controller.getInstance().getManager().getWorkers();
            for (int i = 0; i < threadArray.length; ++i) {
                this.configPanelHolder.add(new ThreadConfigPanel(threadArray[i]));
            }
        }
        return this.configPanelHolder;
    }

    private JScrollPane getConfigScroller() {
        if (this.configScroller == null) {
            this.configScroller = new JScrollPane();
            this.configScroller.setViewportView(this.getScrolingPanel());
            this.configScroller.setBorder(BorderFactory.createTitledBorder("Threads"));
        }
        return this.configScroller;
    }

    private JPanel getScrolingPanel() {
        if (this.scrolingPanel == null) {
            this.scrolingPanel = new JPanel();
            this.scrolingPanel.setLayout(new FlowLayout());
            this.scrolingPanel.add((Component)this.getConfigPanelHolder(), null);
        }
        return this.scrolingPanel;
    }
}

