/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mandelbrot.view;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ThreadConfigPanel
extends JPanel {
    public static final String rcsHeader = "$Header: /data/cvs/diplomarbeit/JTSFraktal/src/ch/skybeam/mandelbrot/view/ThreadConfigPanel.java,v 1.2 2006/11/05 16:51:51 rme Exp $";
    public static final String rcsName = "$Name:  $";
    public static final String rcsRevision = "$Revision: 1.2 $";
    private static final long serialVersionUID = 1L;
    protected Thread thread;
    private JLabel nameLabel = null;
    private JTextField nameField = null;
    private JLabel priorityLabel = null;
    private JComboBox prioritySelector = null;
    private JButton updateButton = null;

    public ThreadConfigPanel() {
        this.initialize();
    }

    public ThreadConfigPanel(Thread thread) {
        this.thread = thread;
        this.initialize();
    }

    private void initialize() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        this.priorityLabel = new JLabel();
        this.priorityLabel.setText("Priotity:");
        this.nameLabel = new JLabel();
        this.nameLabel.setText("Name:");
        this.setLayout(flowLayout);
        this.setSize(500, 48);
        this.add((Component)this.nameLabel, null);
        this.add((Component)this.getNameField(), null);
        this.add((Component)this.priorityLabel, null);
        this.add((Component)this.getPrioritySelector(), null);
        this.add((Component)this.getUpdateButton(), null);
    }

    private JTextField getNameField() {
        if (this.nameField == null) {
            this.nameField = new JTextField();
            this.nameField.setColumns(20);
            this.nameField.setText(this.thread.getName());
        }
        return this.nameField;
    }

    private JComboBox getPrioritySelector() {
        if (this.prioritySelector == null) {
            this.prioritySelector = new JComboBox();
            for (int i = 1; i <= 10; ++i) {
                Integer n = new Integer(i);
                this.prioritySelector.addItem(n);
                if (i != this.thread.getPriority()) continue;
                this.prioritySelector.setSelectedItem(n);
            }
        }
        return this.prioritySelector;
    }

    public void updateThreadConfiguration() {
        Integer n = (Integer)this.getPrioritySelector().getSelectedItem();
        this.thread.setPriority(n);
        this.thread.setName(this.getNameField().getText());
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ThreadConfigPanel.this.updateThreadConfiguration();
                }
            });
        }
        return this.updateButton;
    }
}

