/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mandelbrot.view;

import ch.skybeam.mandelbrot.control.Controller;
import ch.skybeam.mandelbrot.model.BookmarkItem;
import ch.skybeam.mandelbrot.view.BookmarkDialog;
import ch.skybeam.mandelbrot.view.ConfigDialog;
import ch.skybeam.mandelbrot.view.ThreadConfiguration;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class MandelbrotGUI
extends JFrame {
    public static final String rcsHeader = "$Header: /data/cvs/diplomarbeit/JTSFraktal/src/ch/skybeam/mandelbrot/view/MandelbrotGUI.java,v 1.15 2006/11/11 15:41:26 rme Exp $";
    public static final String rcsName = "$Name:  $";
    public static final String rcsRevision = "$Revision: 1.15 $";
    private static final long serialVersionUID = 1L;
    private String calculationText = "Last calculation time: ";
    protected BufferedImage image;
    protected Controller controller;
    protected Rectangle selectionRectangle = null;
    protected Point clickPoint = new Point(0, 0);
    private Component imageComponent;
    private JPanel contentPanel = null;
    private JMenuBar mainMenu = null;
    private JMenu fileMenu = null;
    private JMenuItem exitMenuItem = null;
    private JMenu configurationMenu = null;
    private JMenuItem confThreadsMenuItem = null;
    private JMenuItem confGeneral = null;
    private JMenu actionMenu = null;
    private JMenuItem restartItem = null;
    private JMenuItem stopItem = null;
    private JMenuItem colorMapItem = null;
    private JMenuItem resetCoordinatesItem = null;
    private JMenu bookmarkMenu = null;
    private JMenu allBookmarksMenu = null;
    private JMenuItem addBookmarkItem = null;
    private JMenuItem saveBookmarkItem = null;
    private JMenuItem loadBookmarkItem = null;
    private JMenuItem clearBookmarkItem = null;
    private JMenuItem saveImageItem = null;
    private JMenu resultMenu = null;
    private long calculationTime;

    public MandelbrotGUI() {
        this.initialize();
    }

    private void initialize() {
        this.controller = Controller.getInstance();
        this.setSize(1024, 768);
        this.setJMenuBar(this.getMainMenu());
        this.setContentPane(this.getContentPanel());
        this.setDefaultCloseOperation(0);
        this.setTitle("Mandelbrot");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MandelbrotGUI.this.controller.quit();
            }
        });
    }

    private Component getImageComponent() {
        if (this.imageComponent == null) {
            this.imageComponent = new Component(){
                private static final long serialVersionUID = 1L;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void paint(Graphics g) {
                    super.paint(g);
                    g.drawImage(MandelbrotGUI.this.image, 0, 0, null);
                    g.setColor(new Color(255, 255, 255));
                    if (MandelbrotGUI.this.selectionRectangle != null) {
                        Rectangle rectangle = MandelbrotGUI.this.selectionRectangle;
                        synchronized (rectangle) {
                            g.drawRect(MandelbrotGUI.this.selectionRectangle.x, MandelbrotGUI.this.selectionRectangle.y, MandelbrotGUI.this.selectionRectangle.width, MandelbrotGUI.this.selectionRectangle.height);
                        }
                    }
                }
            };
        }
        return this.imageComponent;
    }

    protected void createImage() {
        this.controller.setImage(this.getContentPanel().getWidth(), this.getContentPanel().getHeight());
    }

    public void drawImage(BufferedImage drawImage) {
        this.image = drawImage;
        this.getContentPanel().repaint();
    }

    public void updateBookmarks(BookmarkItem[] items) {
        this.getAllBookmarksMenu().removeAll();
        if (items.length > 0) {
            int i = 0;
            while (i < items.length) {
                this.getAllBookmarksMenu().add(new BookmarkMenuItem(items[i]));
                ++i;
            }
        } else {
            this.getAllBookmarksMenu().add(new JMenuItem("[No bookmarks]"));
        }
    }

    public void saveImage() {
        if (this.image != null) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileFilter(new ExtensionFilter(".png", true));
            int returnvalue = chooser.showSaveDialog(this);
            if (returnvalue == 0) {
                try {
                    File target = chooser.getSelectedFile().getPath().endsWith(".png") ? chooser.getSelectedFile() : new File(String.valueOf(chooser.getSelectedFile().getPath()) + ".png");
                    ImageIO.write((RenderedImage)this.image, "PNG", target);
                }
                catch (IOException e) {
                    System.err.println("Error writing to the file");
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.err.println("No image available to save!");
        }
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new BorderLayout());
            this.contentPanel.add(this.getImageComponent(), "Center");
            this.contentPanel.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    MandelbrotGUI.this.createImage();
                }
            });
            this.contentPanel.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    if (MandelbrotGUI.this.selectionRectangle != null && MandelbrotGUI.this.selectionRectangle.getWidth() > 0.0 && MandelbrotGUI.this.selectionRectangle.getHeight() > 0.0) {
                        MandelbrotGUI.this.controller.setZoom(MandelbrotGUI.this.selectionRectangle);
                    }
                    MandelbrotGUI.this.selectionRectangle = null;
                    MandelbrotGUI.this.repaint();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void mousePressed(MouseEvent e) {
                    Point point = MandelbrotGUI.this.clickPoint;
                    synchronized (point) {
                        MandelbrotGUI.this.clickPoint.setLocation(e.getX(), e.getY());
                    }
                    MandelbrotGUI.this.selectionRectangle = new Rectangle();
                }
            });
            this.contentPanel.addMouseMotionListener(new MouseMotionAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void mouseDragged(MouseEvent e) {
                    int width = 0;
                    int height = 0;
                    if (MandelbrotGUI.this.image != null) {
                        double aspectRatio = (double)MandelbrotGUI.this.image.getWidth() / (double)MandelbrotGUI.this.image.getHeight();
                        Point point = MandelbrotGUI.this.clickPoint;
                        synchronized (point) {
                            int calcWidth = e.getX() - MandelbrotGUI.this.clickPoint.x;
                            int xMult = calcWidth >= 0 ? 1 : -1;
                            int calcHeight = e.getY() - MandelbrotGUI.this.clickPoint.y;
                            int yMult = calcHeight >= 0 ? 1 : -1;
                            int aspectWidth = (int)((double)Math.abs(calcHeight) * aspectRatio);
                            int aspectHeight = (int)((double)Math.abs(calcWidth) / aspectRatio);
                            width = aspectWidth > Math.abs(calcWidth) ? aspectWidth * xMult : calcWidth;
                            height = aspectHeight > Math.abs(calcHeight) ? aspectHeight * yMult : calcHeight;
                        }
                    }
                    if (MandelbrotGUI.this.selectionRectangle != null) {
                        Rectangle rectangle = MandelbrotGUI.this.selectionRectangle;
                        synchronized (rectangle) {
                            MandelbrotGUI.this.selectionRectangle.setFrameFromDiagonal(MandelbrotGUI.this.clickPoint.x, MandelbrotGUI.this.clickPoint.y, MandelbrotGUI.this.clickPoint.x + width, MandelbrotGUI.this.clickPoint.y + height);
                        }
                    }
                    MandelbrotGUI.this.repaint();
                }
            });
        }
        return this.contentPanel;
    }

    private JMenuBar getMainMenu() {
        if (this.mainMenu == null) {
            this.mainMenu = new JMenuBar();
            this.mainMenu.add(this.getFileMenu());
            this.mainMenu.add(this.getConfigurationMenu());
            this.mainMenu.add(this.getActionMenu());
            this.mainMenu.add(this.getBookmarkMenu());
            this.mainMenu.add(this.getResultMenu());
        }
        return this.mainMenu;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            if (!Controller.getInstance().isApplet()) {
                this.fileMenu.add(this.getSaveImageItem());
                this.fileMenu.addSeparator();
                this.fileMenu.add(this.getSaveBookmarkItem());
                this.fileMenu.add(this.getLoadBookmarkItem());
                this.fileMenu.addSeparator();
            }
            this.fileMenu.add(this.getExitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Controller.getInstance().quit();
                }
            });
        }
        return this.exitMenuItem;
    }

    private JMenu getConfigurationMenu() {
        if (this.configurationMenu == null) {
            this.configurationMenu = new JMenu();
            this.configurationMenu.setText("Configuration");
            this.configurationMenu.add(this.getConfThreadsMenuItem());
            this.configurationMenu.add(this.getConfGeneral());
        }
        return this.configurationMenu;
    }

    protected void showThreadConfiguration() {
        new ThreadConfiguration(this).setVisible(true);
    }

    protected void showConfiguration() {
        new ConfigDialog(this).setVisible(true);
    }

    private JMenuItem getConfThreadsMenuItem() {
        if (this.confThreadsMenuItem == null) {
            this.confThreadsMenuItem = new JMenuItem();
            this.confThreadsMenuItem.setText("Thread Configuration");
            this.confThreadsMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MandelbrotGUI.this.showThreadConfiguration();
                }
            });
        }
        return this.confThreadsMenuItem;
    }

    private JMenuItem getConfGeneral() {
        if (this.confGeneral == null) {
            this.confGeneral = new JMenuItem();
            this.confGeneral.setText("General");
            this.confGeneral.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MandelbrotGUI.this.showConfiguration();
                }
            });
        }
        return this.confGeneral;
    }

    protected void performStop() {
        this.controller.interruptCalculation();
    }

    protected void performRestart() {
        this.controller.restartCalculation();
    }

    protected void performAddBookmark() {
        BookmarkDialog dialog = new BookmarkDialog(this);
        dialog.setVisible(true);
    }

    protected void performDrawColorMap() {
        this.controller.drawColorMap();
    }

    protected void performResetCoordinates() {
        this.controller.setMandelbrotCoordinates(-2.0, -1.0, 2.8, true);
    }

    private JMenu getActionMenu() {
        if (this.actionMenu == null) {
            this.actionMenu = new JMenu();
            this.actionMenu.setText("Actions");
            this.actionMenu.add(this.getRestartItem());
            this.actionMenu.add(this.getStopItem());
            this.actionMenu.addSeparator();
            this.actionMenu.add(this.getResetCoordinatesItem());
            this.actionMenu.addSeparator();
            this.actionMenu.add(this.getColorMapItem());
        }
        return this.actionMenu;
    }

    private JMenuItem getRestartItem() {
        if (this.restartItem == null) {
            this.restartItem = new JMenuItem();
            this.restartItem.setText("Restart");
            this.restartItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MandelbrotGUI.this.performRestart();
                }
            });
        }
        return this.restartItem;
    }

    private JMenuItem getStopItem() {
        if (this.stopItem == null) {
            this.stopItem = new JMenuItem();
            this.stopItem.setText("Stop");
            this.stopItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MandelbrotGUI.this.performStop();
                }
            });
        }
        return this.stopItem;
    }

    private JMenuItem getColorMapItem() {
        if (this.colorMapItem == null) {
            this.colorMapItem = new JMenuItem();
            this.colorMapItem.setText("Draw Color Map");
            this.colorMapItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MandelbrotGUI.this.performDrawColorMap();
                }
            });
        }
        return this.colorMapItem;
    }

    private JMenuItem getResetCoordinatesItem() {
        if (this.resetCoordinatesItem == null) {
            this.resetCoordinatesItem = new JMenuItem();
            this.resetCoordinatesItem.setText("Reset Coordinates");
            this.resetCoordinatesItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MandelbrotGUI.this.performResetCoordinates();
                }
            });
        }
        return this.resetCoordinatesItem;
    }

    private JMenu getBookmarkMenu() {
        if (this.bookmarkMenu == null) {
            this.bookmarkMenu = new JMenu();
            this.bookmarkMenu.setText("Bookmarks");
            this.bookmarkMenu.add(this.getAddBookmarkItem());
            this.bookmarkMenu.addSeparator();
            this.bookmarkMenu.add(this.getAllBookmarksMenu());
            this.bookmarkMenu.addSeparator();
            this.bookmarkMenu.add(this.getClearBookmarkItem());
        }
        return this.bookmarkMenu;
    }

    private JMenu getAllBookmarksMenu() {
        if (this.allBookmarksMenu == null) {
            this.allBookmarksMenu = new JMenu();
            this.allBookmarksMenu.setText("All Bookmarks");
            this.updateBookmarks(new BookmarkItem[0]);
        }
        return this.allBookmarksMenu;
    }

    private JMenuItem getAddBookmarkItem() {
        if (this.addBookmarkItem == null) {
            this.addBookmarkItem = new JMenuItem();
            this.addBookmarkItem.setText("Add Bookmark");
            this.addBookmarkItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MandelbrotGUI.this.performAddBookmark();
                }
            });
        }
        return this.addBookmarkItem;
    }

    private JMenuItem getSaveBookmarkItem() {
        if (this.saveBookmarkItem == null) {
            this.saveBookmarkItem = new JMenuItem();
            this.saveBookmarkItem.setText("Save Bookmarks...");
            this.saveBookmarkItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MandelbrotGUI.this.performSaveBookmarks();
                }
            });
        }
        return this.saveBookmarkItem;
    }

    protected void performSaveBookmarks() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new ExtensionFilter(".xml", true));
        int returnvalue = chooser.showSaveDialog(this);
        if (returnvalue == 0) {
            File target = chooser.getSelectedFile().getPath().endsWith(".xml") ? chooser.getSelectedFile() : new File(String.valueOf(chooser.getSelectedFile().getPath()) + ".xml");
            Controller.getInstance().saveBookmarks(target);
        }
    }

    protected void performLoadBookmarks() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new ExtensionFilter(".xml", true));
        int returnvalue = chooser.showOpenDialog(this);
        if (returnvalue == 0) {
            Controller.getInstance().loadBookmarks(chooser.getSelectedFile());
        }
    }

    protected void performClearBookmarks() {
        Controller.getInstance().clearBookmarks();
    }

    private JMenuItem getLoadBookmarkItem() {
        if (this.loadBookmarkItem == null) {
            this.loadBookmarkItem = new JMenuItem();
            this.loadBookmarkItem.setText("Load Bookmarks...");
            this.loadBookmarkItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MandelbrotGUI.this.performLoadBookmarks();
                }
            });
        }
        return this.loadBookmarkItem;
    }

    private JMenuItem getClearBookmarkItem() {
        if (this.clearBookmarkItem == null) {
            this.clearBookmarkItem = new JMenuItem();
            this.clearBookmarkItem.setText("Clear Bookmarks");
            this.clearBookmarkItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MandelbrotGUI.this.performClearBookmarks();
                }
            });
        }
        return this.clearBookmarkItem;
    }

    private JMenuItem getSaveImageItem() {
        if (this.saveImageItem == null) {
            this.saveImageItem = new JMenuItem();
            this.saveImageItem.setText("Save Image...");
            this.saveImageItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MandelbrotGUI.this.saveImage();
                }
            });
        }
        return this.saveImageItem;
    }

    private JMenu getResultMenu() {
        if (this.resultMenu == null) {
            this.resultMenu = new JMenu();
            this.resultMenu.setText(this.calculationText);
            this.resultMenu.setEnabled(false);
        }
        return this.resultMenu;
    }

    public void setCalculationTime(long nanoseconds) {
        this.calculationTime = nanoseconds;
        this.getResultMenu().setText(String.valueOf(this.calculationText) + this.calculationTime / 1000000L + "ms");
    }

    private class ExtensionFilter
    extends FileFilter {
        private String extension;
        private boolean showDirectories;

        public ExtensionFilter(String extension, boolean showDirectories) {
            this.extension = extension;
            this.showDirectories = showDirectories;
        }

        public boolean accept(File f) {
            boolean show = false;
            if (f.isDirectory() && this.showDirectories || f.getName().endsWith(this.extension)) {
                show = true;
            }
            return show;
        }

        public String getDescription() {
            return String.valueOf(this.extension) + " Files";
        }
    }

    private class BookmarkMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        private BookmarkItem item;

        public BookmarkMenuItem(BookmarkItem item) {
            super(item.getName());
            this.item = item;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BookmarkMenuItem.this.performBookmarkJump();
                }
            });
        }

        public BookmarkItem getBookmark() {
            return this.item;
        }

        protected void performBookmarkJump() {
            Controller c = Controller.getInstance();
            c.setMaxIterations(this.item.getMaxIterations(), false);
            c.setMandelbrotCoordinates(this.item.getMandelbrotX(), this.item.getMandelbrotY(), this.item.getMandelbrotWidth(), true);
        }
    }
}

