/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mandelbrot.view;

import ch.skybeam.mandelbrot.control.Controller;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ConfigDialog
extends JDialog {
    public static final String rcsHeader = "$Header: /data/cvs/diplomarbeit/JTSFraktal/src/ch/skybeam/mandelbrot/view/ConfigDialog.java,v 1.8 2006/11/12 12:48:32 rme Exp $";
    public static final String rcsName = "$Name:  $";
    public static final String rcsRevision = "$Revision: 1.8 $";
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JPanel verticalArrangement = null;
    private JPanel threadPanel = null;
    private JPanel iterationsPanel = null;
    private JPanel coordinatesPanel = null;
    private JPanel valuesPanel = null;
    private JPanel note = null;
    private JLabel numThreadsLabel = null;
    private JTextField numThreadsField = null;
    private JLabel numIterationsLabel = null;
    private JTextField numIterationsField = null;
    private JLabel xLabel = null;
    private JTextField xField = null;
    private JLabel yLabel = null;
    private JTextField yField = null;
    private JLabel widthLabel = null;
    private JTextField widthField = null;
    private JTextArea noteArea = null;
    private JPanel lockSelectionPanel = null;
    private JRadioButton fineLockingR = null;
    private JRadioButton noLockingR = null;
    private JRadioButton coarseLockingR = null;
    private JRadioButton CASLockingR = null;
    private JPanel autoRestartPanel = null;
    private JCheckBox autoRestartBox = null;
    private JLabel autoRestartLabel = null;
    private JPanel implTypePanel = null;
    private JRadioButton implTypeJThreadsR = null;
    private JRadioButton implTypeJOMP = null;

    public ConfigDialog(Frame frame) {
        super(frame);
        this.initialize();
    }

    private void initialize() {
        this.setSize(534, 468);
        this.setTitle("Configuration");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getVerticalArrangement(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            flowLayout.setAlignment(2);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getOkButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigDialog.this.performOK();
                }
            });
            this.okButton.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "OK");
            this.okButton.getActionMap().put("OK", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigDialog.this.performOK();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigDialog.this.performCancel();
                }
            });
            this.cancelButton.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
            this.cancelButton.getActionMap().put("Cancel", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    ConfigDialog.this.performCancel();
                }
            });
        }
        return this.cancelButton;
    }

    protected void performCancel() {
        this.dispose();
    }

    protected void performOK() {
        Controller controller = Controller.getInstance();
        controller.setAutoRestart(this.getAutoRestartBox().isSelected());
        if (this.getNoLockingR().isSelected()) {
            controller.setLockType(0);
        } else if (this.getCoarseLockingR().isSelected()) {
            controller.setLockType(1);
        } else if (this.getFineLockingR().isSelected()) {
            controller.setLockType(2);
        } else if (this.getCASLockingR().isSelected()) {
            controller.setLockType(3);
        }
        try {
            int n = Integer.parseInt(this.numIterationsField.getText());
            controller.setMaxIterations(n, false);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Warning: Failed to parse number of iterations.");
        }
        try {
            double d = Double.parseDouble(this.xField.getText());
            double d2 = Double.parseDouble(this.yField.getText());
            double d3 = Double.parseDouble(this.widthField.getText());
            controller.setMandelbrotCoordinates(d, d2, d3, false);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Warning: Failed to parse mandelbrot coordinates.");
        }
        if (this.getImplTypeJOMP().isSelected()) {
            controller.setImplType(1, false);
        } else {
            controller.setImplType(0, false);
        }
        try {
            int n = Integer.parseInt(this.numThreadsField.getText());
            controller.setNumWorkers(n, true);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Warning: Failed to parse number of threads.");
        }
        this.dispose();
    }

    private JPanel getVerticalArrangement() {
        if (this.verticalArrangement == null) {
            this.verticalArrangement = new JPanel();
            this.verticalArrangement.setLayout(new BoxLayout(this.getVerticalArrangement(), 1));
            this.verticalArrangement.add((Component)this.getThreadPanel(), null);
            this.verticalArrangement.add((Component)this.getIterationsPanel(), null);
            this.verticalArrangement.add((Component)this.getLockSelectionPanel(), null);
            if (Controller.getInstance().isJOMPSupport()) {
                this.verticalArrangement.add((Component)this.getImplTypePanel(), null);
            }
            this.verticalArrangement.add((Component)this.getAutoRestartPanel(), null);
            this.verticalArrangement.add((Component)this.getCoordinatesPanel(), null);
        }
        return this.verticalArrangement;
    }

    private JPanel getThreadPanel() {
        if (this.threadPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.numThreadsLabel = new JLabel();
            this.numThreadsLabel.setText("Number of Threads:");
            this.threadPanel = new JPanel();
            this.threadPanel.setLayout(flowLayout);
            this.threadPanel.add((Component)this.numThreadsLabel, null);
            this.threadPanel.add((Component)this.getNumThreadsField(), null);
            this.threadPanel.setBorder(BorderFactory.createTitledBorder("Threads"));
        }
        return this.threadPanel;
    }

    private JPanel getIterationsPanel() {
        if (this.iterationsPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.numIterationsLabel = new JLabel();
            this.numIterationsLabel.setText("Number of iterations:");
            this.iterationsPanel = new JPanel();
            this.iterationsPanel.setLayout(flowLayout);
            this.iterationsPanel.add((Component)this.numIterationsLabel, null);
            this.iterationsPanel.add((Component)this.getNumIterationsField(), null);
            this.iterationsPanel.setBorder(BorderFactory.createTitledBorder("Iterations"));
        }
        return this.iterationsPanel;
    }

    private JPanel getCoordinatesPanel() {
        if (this.coordinatesPanel == null) {
            this.coordinatesPanel = new JPanel();
            this.coordinatesPanel.setLayout(new BorderLayout());
            this.coordinatesPanel.setBorder(BorderFactory.createTitledBorder("Mandelbrot coordinates"));
            this.coordinatesPanel.add((Component)this.getValuesPanel(), "Center");
            this.coordinatesPanel.add((Component)this.getNote(), "South");
        }
        return this.coordinatesPanel;
    }

    private JPanel getValuesPanel() {
        if (this.valuesPanel == null) {
            this.widthLabel = new JLabel();
            this.widthLabel.setText("Width:");
            this.yLabel = new JLabel();
            this.yLabel.setText("Y:");
            this.xLabel = new JLabel();
            this.xLabel.setText("X:");
            this.valuesPanel = new JPanel();
            this.valuesPanel.setLayout(new FlowLayout());
            this.valuesPanel.add((Component)this.xLabel, null);
            this.valuesPanel.add((Component)this.getXField(), null);
            this.valuesPanel.add((Component)this.yLabel, null);
            this.valuesPanel.add((Component)this.getYField(), null);
            this.valuesPanel.add((Component)this.widthLabel, null);
            this.valuesPanel.add((Component)this.getWidthField(), null);
        }
        return this.valuesPanel;
    }

    private JPanel getNote() {
        if (this.note == null) {
            this.note = new JPanel();
            this.note.setLayout(new BorderLayout());
            this.note.add((Component)this.getNoteArea(), "South");
        }
        return this.note;
    }

    private JTextField getNumThreadsField() {
        if (this.numThreadsField == null) {
            this.numThreadsField = new JTextField();
            this.numThreadsField.setColumns(2);
            this.numThreadsField.setHorizontalAlignment(11);
            this.numThreadsField.setText(Integer.toString(Controller.getInstance().getNumWorkers()));
        }
        return this.numThreadsField;
    }

    private JTextField getNumIterationsField() {
        if (this.numIterationsField == null) {
            this.numIterationsField = new JTextField();
            this.numIterationsField.setColumns(4);
            this.numIterationsField.setHorizontalAlignment(11);
            this.numIterationsField.setText(Integer.toString(Controller.getInstance().getMaxIterations()));
        }
        return this.numIterationsField;
    }

    private JTextField getXField() {
        if (this.xField == null) {
            this.xField = new JTextField();
            this.xField.setColumns(15);
            this.xField.setHorizontalAlignment(11);
            this.xField.setText(Double.toString(Controller.getInstance().getMandelbrotX()));
        }
        return this.xField;
    }

    private JTextField getYField() {
        if (this.yField == null) {
            this.yField = new JTextField();
            this.yField.setColumns(15);
            this.yField.setHorizontalAlignment(11);
            this.yField.setText(Double.toString(Controller.getInstance().getMandelbrotY()));
        }
        return this.yField;
    }

    private JTextField getWidthField() {
        if (this.widthField == null) {
            this.widthField = new JTextField();
            this.widthField.setColumns(15);
            this.widthField.setHorizontalAlignment(11);
            this.widthField.setText(Double.toString(Controller.getInstance().getMandelbrotWidth()));
        }
        return this.widthField;
    }

    private JTextArea getNoteArea() {
        if (this.noteArea == null) {
            this.noteArea = new JTextArea();
            this.noteArea.setText("Note: Hight is not set here since it's calculated on-the-fly using the width value and the main window aspect ratio.");
            this.noteArea.setEditable(false);
            this.noteArea.setEnabled(true);
            this.noteArea.setLineWrap(true);
        }
        return this.noteArea;
    }

    private JPanel getLockSelectionPanel() {
        if (this.lockSelectionPanel == null) {
            this.lockSelectionPanel = new JPanel();
            this.lockSelectionPanel.setLayout(new FlowLayout());
            this.lockSelectionPanel.setBorder(BorderFactory.createTitledBorder("Locking"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.getFineLockingR());
            buttonGroup.add(this.getNoLockingR());
            buttonGroup.add(this.getCoarseLockingR());
            buttonGroup.add(this.getCASLockingR());
            this.lockSelectionPanel.add((Component)this.getNoLockingR(), null);
            this.lockSelectionPanel.add((Component)this.getCoarseLockingR(), null);
            this.lockSelectionPanel.add((Component)this.getFineLockingR(), null);
            this.lockSelectionPanel.add((Component)this.getCASLockingR(), null);
            switch (Controller.getInstance().getLockType()) {
                case 0: {
                    this.getNoLockingR().setSelected(true);
                    break;
                }
                case 1: {
                    this.getCoarseLockingR().setSelected(true);
                    break;
                }
                case 2: {
                    this.getFineLockingR().setSelected(true);
                    break;
                }
                case 3: {
                    this.getCASLockingR().setSelected(true);
                    break;
                }
                default: {
                    this.getNoLockingR().setSelected(true);
                }
            }
        }
        return this.lockSelectionPanel;
    }

    private JRadioButton getFineLockingR() {
        if (this.fineLockingR == null) {
            this.fineLockingR = new JRadioButton();
            this.fineLockingR.setText("Fine grained locking");
        }
        return this.fineLockingR;
    }

    private JRadioButton getNoLockingR() {
        if (this.noLockingR == null) {
            this.noLockingR = new JRadioButton();
            this.noLockingR.setText("No locking");
        }
        return this.noLockingR;
    }

    private JRadioButton getCoarseLockingR() {
        if (this.coarseLockingR == null) {
            this.coarseLockingR = new JRadioButton();
            this.coarseLockingR.setText("Coarse grained locking");
        }
        return this.coarseLockingR;
    }

    private JRadioButton getCASLockingR() {
        if (this.CASLockingR == null) {
            this.CASLockingR = new JRadioButton();
            this.CASLockingR.setText("CAS \"locking\"");
        }
        return this.CASLockingR;
    }

    private JPanel getAutoRestartPanel() {
        if (this.autoRestartPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            this.autoRestartLabel = new JLabel();
            this.autoRestartLabel.setText("Automatically restart calculation:");
            this.autoRestartPanel = new JPanel();
            this.autoRestartPanel.setLayout(flowLayout);
            this.autoRestartPanel.add((Component)this.autoRestartLabel, null);
            this.autoRestartPanel.add((Component)this.getAutoRestartBox(), null);
            this.autoRestartPanel.setBorder(BorderFactory.createTitledBorder("Re-calculation"));
        }
        return this.autoRestartPanel;
    }

    private JCheckBox getAutoRestartBox() {
        if (this.autoRestartBox == null) {
            this.autoRestartBox = new JCheckBox();
            this.autoRestartBox.setText("Automatically restart");
            this.autoRestartBox.setSelected(Controller.getInstance().isAutoRestart());
        }
        return this.autoRestartBox;
    }

    private JPanel getImplTypePanel() {
        if (this.implTypePanel == null) {
            this.implTypePanel = new JPanel();
            this.implTypePanel.setLayout(new FlowLayout());
            this.implTypePanel.setBorder(BorderFactory.createTitledBorder("Implementation Type"));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.getImplTypeJThreadsR());
            buttonGroup.add(this.getImplTypeJOMP());
            this.implTypePanel.add((Component)this.getImplTypeJThreadsR(), null);
            this.implTypePanel.add((Component)this.getImplTypeJOMP(), null);
        }
        return this.implTypePanel;
    }

    private JRadioButton getImplTypeJThreadsR() {
        if (this.implTypeJThreadsR == null) {
            this.implTypeJThreadsR = new JRadioButton();
            this.implTypeJThreadsR.setText("Java Threads");
            if (Controller.getInstance().getImplType() == 0) {
                this.implTypeJThreadsR.setSelected(true);
            }
        }
        return this.implTypeJThreadsR;
    }

    private JRadioButton getImplTypeJOMP() {
        if (this.implTypeJOMP == null) {
            this.implTypeJOMP = new JRadioButton();
            this.implTypeJOMP.setText("JOMP");
            if (Controller.getInstance().getImplType() == 1) {
                this.implTypeJOMP.setSelected(true);
            }
        }
        return this.implTypeJOMP;
    }
}

