/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mandelbrot.view;

import ch.skybeam.mandelbrot.control.Controller;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class BookmarkDialog
extends JDialog {
    public static final String rcsHeader = "$Header$";
    public static final String rcsName = "$Name$";
    public static final String rcsRevision = "$Revision$";
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel buttonPanel = null;
    private JPanel textPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JLabel nameLabel = null;
    private JTextField nameText = null;

    public BookmarkDialog(Frame frame) {
        super(frame);
        this.initialize();
    }

    private void initialize() {
        this.setSize(408, 136);
        this.setTitle("Bookmark name...");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
            this.jContentPane.add((Component)this.getTextPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            flowLayout.setAlignment(2);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.add((Component)this.getOkButton(), null);
            this.buttonPanel.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPanel;
    }

    private JPanel getTextPanel() {
        if (this.textPanel == null) {
            this.nameLabel = new JLabel();
            this.nameLabel.setText("Name:");
            this.textPanel = new JPanel();
            this.textPanel.setLayout(new FlowLayout());
            this.textPanel.add((Component)this.nameLabel, null);
            this.textPanel.add((Component)this.getNameText(), null);
        }
        return this.textPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setText("OK");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BookmarkDialog.this.performOK();
                }
            });
            this.okButton.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "OK");
            this.okButton.getActionMap().put("OK", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    BookmarkDialog.this.performOK();
                }
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BookmarkDialog.this.performCancel();
                }
            });
            this.cancelButton.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
            this.cancelButton.getActionMap().put("Cancel", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    BookmarkDialog.this.performCancel();
                }
            });
        }
        return this.cancelButton;
    }

    private JTextField getNameText() {
        if (this.nameText == null) {
            this.nameText = new JTextField();
            this.nameText.setColumns(20);
        }
        return this.nameText;
    }

    protected void performOK() {
        Controller.getInstance().addBookmark(this.nameText.getText());
        this.dispose();
    }

    protected void performCancel() {
        this.dispose();
    }
}

