/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mandelbrot.model;

import ch.skybeam.mandelbrot.model.BenchmarkManager;
import ch.skybeam.mandelbrot.model.CalculatorInterface;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerThread
extends Thread {
    public static final String rcsHeader = "$Header: /data/cvs/diplomarbeit/JTSFraktal/src/ch/skybeam/mandelbrot/model/WorkerThread.java,v 1.2 2006/11/05 15:19:18 rme Exp $";
    public static final String rcsName = "$Name:  $";
    public static final String rcsRevision = "$Revision: 1.2 $";
    private AtomicBoolean cancelProcessing = new AtomicBoolean(false);
    private CyclicBarrier startBarrier;
    private CyclicBarrier finishBarrier;
    private CalculatorInterface currentJob;
    private LinkedBlockingQueue<BenchmarkManager.BenchmarkJob> jobQueue;

    public WorkerThread(LinkedBlockingQueue<BenchmarkManager.BenchmarkJob> jobQueue) {
        this.jobQueue = jobQueue;
    }

    @Override
    public void interrupt() {
        if (this.currentJob != null) {
            this.currentJob.interruptCalculation();
        }
        super.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                BenchmarkManager.BenchmarkJob job = this.jobQueue.take();
                WorkerThread workerThread = this;
                synchronized (workerThread) {
                    this.cancelProcessing.set(false);
                    this.startBarrier = job.getStartBarrier();
                    this.finishBarrier = job.getFinishBarrier();
                    this.currentJob = job.getCalculator();
                }
                if (!this.cancelProcessing.get()) {
                    this.startBarrier.await();
                }
                this.currentJob.run();
                if (this.cancelProcessing.get()) continue;
                System.out.println("Thread " + this.getName() + " done (Priority " + this.getPriority() + ")");
                this.finishBarrier.await();
            }
            catch (InterruptedException e) {
                this.interrupt();
            }
            catch (BrokenBarrierException brokenBarrierException) {
                // empty catch block
            }
        }
        System.out.println("Thread " + this.getName() + " done!");
    }

    public synchronized void stopCalculation() {
        this.cancelProcessing.set(true);
        if (this.currentJob != null) {
            this.currentJob.interruptCalculation();
        }
        if (this.startBarrier != null) {
            this.startBarrier.reset();
        }
        if (this.finishBarrier != null) {
            this.finishBarrier.reset();
        }
    }
}

