/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mandelbrot.model;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Settings {
    public static final String rcsHeader = "$Header: /data/cvs/diplomarbeit/JTSFraktal/src/ch/skybeam/mandelbrot/model/Settings.java,v 1.4 2006/11/11 12:57:09 rme Exp $";
    public static final String rcsName = "$Name:  $";
    public static final String rcsRevision = "$Revision: 1.4 $";
    public static final String ELEMENT_ROOT = "settings";
    public static final String ATTRIBUTE_LOCKTYPE = "lockType";
    public static final String ATTRIBUTE_MANDELBROT_X = "mandelbrotX";
    public static final String ATTRIBUTE_MANDELBROT_Y = "mandelbrotY";
    public static final String ATTRIBUTE_MANDELBROT_WIDTH = "mandelbrotWidth";
    public static final String ATTRIBUTE_WORKER_NUMBER = "numWorkers";
    public static final String ATTRIBUTE_MAX_ITERATION = "maxIteration";
    public static final String ATTRIBUTE_AUTORESTART = "autoRestart";
    public static final String ATTRIBUTE_IMPL_TYPE = "implementationType";
    public static final int LOCK_TYPE_NOLOCK = 0;
    public static final int LOCK_TYPE_COARSE = 1;
    public static final int LOCK_TYPE_FINE = 2;
    public static final int IMPL_TYPE_JTHREAD = 0;
    public static final int IMPL_TYPE_JOMP = 1;
    public static final int LOCK_TYPE_CAS = 3;
    public static final double DEFAULT_MANDELBROT_WIDTH = 2.8;
    public static final double DEFAULT_MANDELBROT_X = -2.0;
    public static final double DEFAULT_MANDELBROT_Y = -1.0;
    private volatile double mandelbrotWidth = 2.8;
    private volatile double mandelbrotX = -2.0;
    private volatile double mandelbrotY = -1.0;
    private volatile int maxIterations = 200;
    private volatile int lockType = 0;
    private volatile int numWorkers = 4;
    private volatile int implType = 0;
    private volatile boolean autoRestart = true;
    private volatile boolean JOMPSupport = false;

    public boolean isJOMPSupport() {
        return this.JOMPSupport;
    }

    public void setJOMPSupport(boolean bl) {
        this.JOMPSupport = bl;
        if (!this.JOMPSupport && this.getImplType() == 1) {
            this.setImplType(0);
        }
    }

    public void saveConfiguration(File file) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            document.appendChild(this.getDOM(document));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            Properties properties = new Properties();
            properties.setProperty("indent", "yes");
            transformer.setOutputProperties(properties);
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(file);
            transformer.transform(dOMSource, streamResult);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Parser configuration error");
            parserConfigurationException.printStackTrace();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.out.println("Transformer configuration error");
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            System.out.println("Transformer error");
            transformerException.printStackTrace();
        }
    }

    public void loadConfiguration(File file) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            Element element = document.getDocumentElement();
            this.setDOM(element);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Unable to create document builder");
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            System.out.println("Unable to parse XML file");
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("Unable to read from file");
            iOException.printStackTrace();
        }
    }

    public Element getDOM(Document document) {
        Element element = document.createElement(ELEMENT_ROOT);
        Comment comment = document.createComment("This document was automatically created, please do not edit manually");
        document.appendChild(comment);
        element.setAttribute(ATTRIBUTE_LOCKTYPE, Integer.toString(this.lockType));
        element.setAttribute(ATTRIBUTE_MANDELBROT_X, Double.toString(this.mandelbrotX));
        element.setAttribute(ATTRIBUTE_MANDELBROT_Y, Double.toString(this.mandelbrotY));
        element.setAttribute(ATTRIBUTE_MANDELBROT_WIDTH, Double.toString(this.mandelbrotWidth));
        element.setAttribute(ATTRIBUTE_MAX_ITERATION, Integer.toString(this.maxIterations));
        element.setAttribute(ATTRIBUTE_WORKER_NUMBER, Integer.toString(this.numWorkers));
        element.setAttribute(ATTRIBUTE_AUTORESTART, Boolean.toString(this.autoRestart));
        element.setAttribute(ATTRIBUTE_IMPL_TYPE, Integer.toString(this.implType));
        return element;
    }

    public void setDOM(Element element) {
        if (element.getNodeName().equals(ELEMENT_ROOT)) {
            try {
                int n = Integer.parseInt(element.getAttribute(ATTRIBUTE_LOCKTYPE));
                double d = Double.parseDouble(element.getAttribute(ATTRIBUTE_MANDELBROT_X));
                double d2 = Double.parseDouble(element.getAttribute(ATTRIBUTE_MANDELBROT_Y));
                double d3 = Double.parseDouble(element.getAttribute(ATTRIBUTE_MANDELBROT_WIDTH));
                int n2 = Integer.parseInt(element.getAttribute(ATTRIBUTE_MAX_ITERATION));
                int n3 = Integer.parseInt(element.getAttribute(ATTRIBUTE_WORKER_NUMBER));
                boolean bl = Boolean.parseBoolean(element.getAttribute(ATTRIBUTE_AUTORESTART));
                int n4 = Integer.parseInt(element.getAttribute(ATTRIBUTE_IMPL_TYPE));
                this.setLockType(n);
                this.setMandelbrotX(d);
                this.setMandelbrotY(d2);
                this.setMandelbrotWidth(d3);
                this.setMaxIterations(n2);
                this.setNumWorkers(n3);
                this.setImplType(n4);
                this.setAutoRestart(bl);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Unable to parse attributes. Ignoring configuration");
            }
        } else {
            System.err.println("Invalid XML file specified");
        }
    }

    public int getLockType() {
        return this.lockType;
    }

    public void setLockType(int n) {
        this.lockType = n;
    }

    public double getMandelbrotWidth() {
        return this.mandelbrotWidth;
    }

    public void setMandelbrotWidth(double d) {
        this.mandelbrotWidth = d;
    }

    public double getMandelbrotX() {
        return this.mandelbrotX;
    }

    public void setMandelbrotX(double d) {
        this.mandelbrotX = d;
    }

    public double getMandelbrotY() {
        return this.mandelbrotY;
    }

    public void setMandelbrotY(double d) {
        this.mandelbrotY = d;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int n) {
        this.maxIterations = n;
    }

    public int getNumWorkers() {
        return this.numWorkers;
    }

    public void setNumWorkers(int n) {
        this.numWorkers = n;
    }

    public boolean isAutoRestart() {
        return this.autoRestart;
    }

    public void setAutoRestart(boolean bl) {
        this.autoRestart = bl;
    }

    public int getImplType() {
        int n = this.implType;
        if (this.implType == 1 && !this.isJOMPSupport()) {
            n = 0;
            System.out.println("Warning, JOMP was selected but JOMP is not supported, falling back to Java Threads support");
        }
        return n;
    }

    public void setImplType(int n) {
        this.implType = n;
    }
}

