/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mandelbrot.model;

import ch.skybeam.mandelbrot.control.Controller;
import ch.skybeam.mandelbrot.model.CalculatorInterface;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicBoolean;

public class MandelbrotCalculator
implements CalculatorInterface {
    protected static int numColors = 1792;
    public static Object[] colors = new Object[numColors];
    protected static int[] colorNotPart;
    protected int maxIteration = 200;
    protected Object calculationLock = new Object();
    protected BufferedImage image;
    protected Rectangle imageRenderArea;
    protected Rectangle2D.Double mandelbrotCoordinates;
    protected AtomicBoolean interruptCalculation = new AtomicBoolean(false);

    static {
        int redValue = 0;
        int greenValue = 0;
        int blueValue = 0;
        int i = 1;
        while (i < 8) {
            int redInc = 0;
            if ((i - 1 & 4) == 0 && (i & 4) == 4) {
                redInc = 1;
                redValue = -1;
            } else if ((i - 1 & 4) == 4 && (i & 4) == 0) {
                redInc = -1;
                redValue = 256;
            }
            int greenInc = 0;
            if ((i - 1 & 2) == 0 && (i & 2) == 2) {
                greenInc = 1;
                greenValue = -1;
            } else if ((i - 1 & 2) == 2 && (i & 2) == 0) {
                greenInc = -1;
                greenValue = 256;
            }
            int blueInc = 0;
            if ((i - 1 & 1) == 0 && (i & 1) == 1) {
                blueInc = 1;
                blueValue = -1;
            } else if ((i - 1 & 1) == 1 && (i & 1) == 0) {
                blueInc = -1;
                blueValue = 256;
            }
            int j = 0;
            while (j < 256) {
                int[] color = new int[]{(redValue += redInc) << 16 | (greenValue += greenInc) << 8 | (blueValue += blueInc)};
                MandelbrotCalculator.colors[(i - 1) * 256 + j] = color;
                j = (char)(j + 1);
            }
            i = (byte)(i + 1);
        }
        colorNotPart = new int[]{0x141414};
    }

    public static final double calcMagnitude(double a, double b) {
        double mag = Math.sqrt(a * a + b * b);
        return mag;
    }

    public static final double calcMultiplyImaginary(double a, double b, double c, double d) {
        return a * d + b * c;
    }

    public static final double calcMultiplyReal(double a, double b, double c, double d) {
        return a * c - b * d;
    }

    public MandelbrotCalculator(BufferedImage image, Rectangle renderArea, double mandelbrotX, double mandelbrotY, double mandelbrotWidth, int maxIteration) {
        this.setImage(image);
        this.setRenderArea(renderArea);
        this.setMandelbrotCoordinates(mandelbrotX, mandelbrotY, mandelbrotWidth);
        this.setMaxIteration(maxIteration);
    }

    public MandelbrotCalculator(BufferedImage image, Rectangle renderArea, Rectangle2D.Double mandelbrotCoordinates, int maxIteration) {
        this.setImage(image);
        this.setRenderArea(renderArea);
        this.setMandelbrotCoordinates(mandelbrotCoordinates);
        this.setMaxIteration(maxIteration);
    }

    public void interruptCalculation() {
        this.interruptCalculation.set(true);
    }

    public int mandelbrotTest(double a, double bi) {
        int number = 0;
        double z = 0.0;
        double zi = 0.0;
        while (number <= this.maxIteration && MandelbrotCalculator.calcMagnitude(z, zi) < 2.0) {
            ++number;
            double atmp = MandelbrotCalculator.calcMultiplyReal(z, zi, z, zi);
            double btmp = MandelbrotCalculator.calcMultiplyImaginary(z, zi, z, zi);
            z = atmp;
            zi = btmp;
            z += a;
            zi += bi;
        }
        if (number > this.maxIteration) {
            return -1;
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.calculationLock;
        synchronized (object) {
            double mandelbrotRenderX = this.mandelbrotCoordinates.x + this.mandelbrotCoordinates.width / (double)this.image.getWidth() * (double)(this.imageRenderArea.x + 1);
            double mandelbrotRenderY = this.mandelbrotCoordinates.y + this.mandelbrotCoordinates.height / (double)this.image.getHeight() * (double)(this.imageRenderArea.y + 1);
            double mandelbrotRenderWidth = this.mandelbrotCoordinates.width / (double)this.image.getWidth() * (double)this.imageRenderArea.width;
            double mandelbrotRenderHeight = this.mandelbrotCoordinates.height / (double)this.image.getHeight() * (double)this.imageRenderArea.height;
            double distanceX = mandelbrotRenderWidth / (double)this.imageRenderArea.width;
            double distanceY = mandelbrotRenderHeight / (double)this.imageRenderArea.height;
            double z = mandelbrotRenderX;
            double zi = mandelbrotRenderY;
            int iterations = 0;
            double colorspacing = (double)(numColors - 1) / (double)this.maxIteration;
            System.out.println("Calculating...");
            System.out.println("X: " + (this.imageRenderArea.x + 1) + " to " + (this.imageRenderArea.x + this.imageRenderArea.width));
            System.out.println("Y: " + (this.imageRenderArea.y + 1) + " to " + (this.imageRenderArea.y + this.imageRenderArea.height));
            int x = this.imageRenderArea.x;
            while (x < this.imageRenderArea.x + this.imageRenderArea.width && !this.interruptCalculation.get()) {
                zi = mandelbrotRenderY;
                int y = this.imageRenderArea.y;
                while (y < this.imageRenderArea.y + this.imageRenderArea.height && !this.interruptCalculation.get()) {
                    iterations = this.mandelbrotTest(z, zi);
                    if (iterations != -1) {
                        int colorIndex = (int)(colorspacing * (double)iterations);
                        this.image.setRGB(x, y, 1, 1, (int[])colors[colorIndex], 0, 1);
                    } else {
                        this.image.setRGB(x, y, 1, 1, colorNotPart, 0, 1);
                    }
                    if (x % 50 == 0) {
                        Controller.getInstance().drawImage(this.image);
                    }
                    zi += distanceY;
                    ++y;
                }
                z += distanceX;
                ++x;
            }
            Controller.getInstance().drawImage(this.image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setImage(BufferedImage image) {
        this.interruptCalculation.set(true);
        Object object = this.calculationLock;
        synchronized (object) {
            this.image = image;
        }
        this.interruptCalculation.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMandelbrotCoordinates(double x, double y, double width) {
        this.interruptCalculation.set(true);
        Object object = this.calculationLock;
        synchronized (object) {
            double aspectRatio = (double)this.image.getHeight() / (double)this.image.getWidth();
            this.setMandelbrotCoordinates(new Rectangle2D.Double(x, y, width, width * aspectRatio));
        }
        this.interruptCalculation.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMandelbrotCoordinates(Rectangle2D.Double coordinates) {
        this.interruptCalculation.set(true);
        Object object = this.calculationLock;
        synchronized (object) {
            this.mandelbrotCoordinates = coordinates;
        }
        this.interruptCalculation.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setMaxIteration(int maxIteration) {
        this.interruptCalculation.set(true);
        Object object = this.calculationLock;
        synchronized (object) {
            this.maxIteration = maxIteration;
        }
        this.interruptCalculation.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRenderArea(Rectangle area) {
        this.interruptCalculation.set(true);
        Object object = this.calculationLock;
        synchronized (object) {
            this.imageRenderArea = area;
        }
        this.interruptCalculation.set(false);
    }
}

