/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mandelbrot.model;

import ch.skybeam.mandelbrot.model.BookmarkItem;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BookmarkManager {
    public static final String rcsHeader = "$Header$";
    public static final String rcsName = "$Name$";
    public static final String rcsRevision = "$Revision$";
    public static String ELEMENT_ROOT = "bookmarkSet";
    private Vector<BookmarkItem> items = new Vector();

    public BookmarkItem[] getItems() {
        return this.items.toArray(new BookmarkItem[0]);
    }

    public void clearItems() {
        this.items.clear();
    }

    public void saveConfiguration(File file) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
            document.appendChild(this.getDOM(document));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            Properties properties = new Properties();
            properties.setProperty("indent", "yes");
            transformer.setOutputProperties(properties);
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(file);
            transformer.transform(dOMSource, streamResult);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Parser configuration error");
            parserConfigurationException.printStackTrace();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.out.println("Transformer configuration error");
            transformerConfigurationException.printStackTrace();
        }
        catch (TransformerException transformerException) {
            System.out.println("Transformer error");
            transformerException.printStackTrace();
        }
    }

    public Element getDOM(Document document) {
        Element element = document.createElement(ELEMENT_ROOT);
        Comment comment = document.createComment("This document was automatically created, please do not edit manually");
        document.appendChild(comment);
        for (BookmarkItem bookmarkItem : this.items) {
            element.appendChild(bookmarkItem.getDOM(document));
        }
        return element;
    }

    public boolean addItem(BookmarkItem bookmarkItem) {
        return this.items.add(bookmarkItem);
    }

    public boolean removeItem(BookmarkItem bookmarkItem) {
        return this.items.remove(bookmarkItem);
    }

    public void setDOM(Element element) {
        if (element.getNodeName().equals(ELEMENT_ROOT)) {
            NodeList nodeList = element.getElementsByTagName(BookmarkItem.ELEMENT_BOOKMARK);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                this.addItem(new BookmarkItem(element2));
            }
        } else {
            System.err.println("Invalid XML file specified");
        }
    }

    public void loadConfiguration(File file) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            Element element = document.getDocumentElement();
            this.setDOM(element);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println("Unable to create document builder");
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            System.out.println("Unable to parse XML file");
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("Unable to read from file");
            iOException.printStackTrace();
        }
    }
}

