/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mandelbrot.model;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BookmarkItem {
    public static final String rcsHeader = "$Header$";
    public static final String rcsName = "$Name$";
    public static final String rcsRevision = "$Revision$";
    public static String ELEMENT_BOOKMARK = "bookmark";
    public static String ELEMENT_MANDELBROT_X = "mandelbrotX";
    public static String ELEMENT_MANDELBROT_Y = "mandelbrotY";
    public static String ELEMENT_MANDELBROT_WIDTH = "mandelbrotWidth";
    public static String ELEMENT_MAXITER = "maxIteration";
    public static String ELEMENT_NAME = "name";
    private String name = "bookmarks";
    private double mandelbrotX = 0.0;
    private double mandelbrotY = 0.0;
    private double mandelbrotWidth = 0.0;
    private int maxIterations;

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int n) {
        this.maxIterations = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public BookmarkItem(String string, double d, double d2, double d3, int n) {
        this.name = string;
        this.mandelbrotX = d;
        this.mandelbrotY = d2;
        this.mandelbrotWidth = d3;
        this.maxIterations = n;
    }

    public BookmarkItem(Element element) {
        this.setDOM(element);
    }

    public void setDOM(Element element) {
        if (element.getNodeName().equals(ELEMENT_BOOKMARK)) {
            try {
                this.mandelbrotX = Double.parseDouble(element.getAttribute(ELEMENT_MANDELBROT_X));
                this.mandelbrotY = Double.parseDouble(element.getAttribute(ELEMENT_MANDELBROT_Y));
                this.mandelbrotWidth = Double.parseDouble(element.getAttribute(ELEMENT_MANDELBROT_WIDTH));
                this.name = element.getAttribute(ELEMENT_MAXITER);
                this.maxIterations = Integer.parseInt(this.name);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Error parsing coordinates");
            }
            this.name = element.getAttribute(ELEMENT_NAME);
        } else {
            System.err.println("Invalid XML file specified");
        }
    }

    public Element getDOM(Document document) {
        Element element = document.createElement(ELEMENT_BOOKMARK);
        element.setAttribute(ELEMENT_NAME, this.name);
        element.setAttribute(ELEMENT_MANDELBROT_X, Double.toString(this.mandelbrotX));
        element.setAttribute(ELEMENT_MANDELBROT_Y, Double.toString(this.mandelbrotY));
        element.setAttribute(ELEMENT_MANDELBROT_WIDTH, Double.toString(this.mandelbrotWidth));
        element.setAttribute(ELEMENT_MAXITER, Integer.toString(this.maxIterations));
        return element;
    }

    public double getMandelbrotWidth() {
        return this.mandelbrotWidth;
    }

    public void setMandelbrotWidth(double d) {
        this.mandelbrotWidth = d;
    }

    public double getMandelbrotX() {
        return this.mandelbrotX;
    }

    public void setMandelbrotX(double d) {
        this.mandelbrotX = d;
    }

    public double getMandelbrotY() {
        return this.mandelbrotY;
    }

    public void setMandelbrotY(double d) {
        this.mandelbrotY = d;
    }
}

