/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mandelbrot.model;

import ch.skybeam.mandelbrot.control.Controller;
import ch.skybeam.mandelbrot.model.CalculatorInterface;
import ch.skybeam.mandelbrot.model.MandelbrotCalculator;
import ch.skybeam.mandelbrot.model.WorkerThread;
import ch.skybeam.mandelbrot.model.lock.CountingImage;
import java.awt.Rectangle;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.LinkedBlockingQueue;

public class BenchmarkManager {
    public static final String rcsHeader = "$Header: /data/cvs/diplomarbeit/JTSFraktal/src/ch/skybeam/mandelbrot/model/BenchmarkManager.java,v 1.12 2006/11/11 15:41:43 rme Exp $";
    public static final String rcsName = "$Name:  $";
    public static final String rcsRevision = "$Revision: 1.12 $";
    private int initialThreadPriority = 5;
    protected long startTime = 0L;
    protected long runTime = 0L;
    private WorkerThread[] workers = new WorkerThread[0];
    private LinkedBlockingQueue<BenchmarkJob> jobs = new LinkedBlockingQueue(32);

    public BenchmarkManager(int numWorkers) {
        this.setWorkerNumber(numWorkers);
    }

    public synchronized int setWorkerNumber(int number) {
        if (number < 0) {
            System.out.println("Sorry, cannot create negative number of workers (" + number + ")");
            return this.workers.length;
        }
        this.resetWorkers();
        int numWorkers = this.workers != null ? this.workers.length : 0;
        WorkerThread[] w = new WorkerThread[number];
        int i = 0;
        while (i < Math.max(numWorkers, w.length)) {
            if (i < w.length && i < numWorkers) {
                w[i] = this.workers[i];
            } else if (i >= numWorkers) {
                w[i] = new WorkerThread(this.jobs);
                w[i].setPriority(this.initialThreadPriority);
                w[i].start();
            } else if (i >= w.length) {
                this.workers[i].interrupt();
            }
            ++i;
        }
        this.workers = w;
        return this.workers.length;
    }

    public synchronized Thread[] getWorkers() {
        return this.workers;
    }

    public synchronized void resetWorkers() {
        this.jobs.clear();
        int i = 0;
        while (i < this.workers.length) {
            this.workers[i].stopCalculation();
            ++i;
        }
    }

    public synchronized void setJob(CountingImage image, double mandelbrotX, double mandelbrotY, double mandelbrotWidth, int maxIterations) {
        this.resetWorkers();
        int numWorkers = this.workers.length;
        if (numWorkers > 0) {
            CyclicBarrier startBarrier = new CyclicBarrier(numWorkers, new StartCallback());
            StopCallback stop = new StopCallback();
            stop.image = image;
            CyclicBarrier finishBarrier = new CyclicBarrier(numWorkers, stop);
            double numLines = (double)image.getHeight() / (double)numWorkers;
            int yPrev = 0;
            int i = 1;
            while (i <= numWorkers) {
                int yStart = yPrev;
                yPrev = i == numWorkers ? image.getHeight() : (int)(numLines * (double)i);
                MandelbrotCalculator calc = null;
                switch (Controller.getInstance().getImplType()) {
                    case 1: {
                        try {
                            MandelbrotCalculator calculator = (MandelbrotCalculator)this.getClass().getClassLoader().loadClass("ch.skybeam.mandelbrot.model.MandelbrotCalculatorJOMP").newInstance();
                            calculator.setImage(image);
                            calculator.setRenderArea(new Rectangle(0, yStart, image.getWidth(), yPrev - yStart));
                            calculator.setMandelbrotCoordinates(mandelbrotX, mandelbrotY, mandelbrotWidth);
                            calculator.setMaxIteration(maxIterations);
                            calc = calculator;
                        }
                        catch (InstantiationException e) {
                            System.err.println("JOMP was selected but JOMP calculator could not be instantiated");
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            System.err.println("JOMP was selected but program was unable to access JOMP calculator class");
                            e.printStackTrace();
                        }
                        catch (ClassNotFoundException e) {
                            System.out.println("JOMP was selected but JOMP calculator class does not exist. You need to re-compile with JOMP support!");
                            e.printStackTrace();
                        }
                        break;
                    }
                    default: {
                        calc = new MandelbrotCalculator(image, new Rectangle(0, yStart, image.getWidth(), yPrev - yStart), mandelbrotX, mandelbrotY, mandelbrotWidth, maxIterations);
                    }
                }
                if (calc != null) {
                    BenchmarkJob job = new BenchmarkJob(calc, startBarrier, finishBarrier, image);
                    try {
                        this.jobs.put(job);
                    }
                    catch (InterruptedException e) {
                        System.out.println("Interrupted while putting new job to the queue");
                    }
                } else {
                    System.out.println("Error. No calculator could be created.");
                }
                ++i;
            }
        } else {
            System.out.println("Sorry, no workers available to calculate!");
        }
    }

    public void shutdownWorkers() {
        this.setWorkerNumber(0);
    }

    public class BenchmarkJob {
        private CalculatorInterface calculator;
        private CyclicBarrier startBarrier;
        private CyclicBarrier finishBarrier;
        private CountingImage image;

        public BenchmarkJob(CalculatorInterface calculator, CyclicBarrier startBarrier, CyclicBarrier finishBarrier, CountingImage image) {
            this.calculator = calculator;
            this.startBarrier = startBarrier;
            this.finishBarrier = finishBarrier;
            this.image = image;
        }

        public CyclicBarrier getStartBarrier() {
            return this.startBarrier;
        }

        public CyclicBarrier getFinishBarrier() {
            return this.finishBarrier;
        }

        public CalculatorInterface getCalculator() {
            return this.calculator;
        }

        public CountingImage getImage() {
            return this.image;
        }
    }

    protected class StopCallback
    implements Runnable {
        public CountingImage image;

        protected StopCallback() {
        }

        public void run() {
            long stopTime = System.nanoTime();
            BenchmarkManager.this.runTime = stopTime - BenchmarkManager.this.startTime;
            System.out.println("Run time: " + BenchmarkManager.this.runTime / 1000000L + "ms");
            Controller.getInstance().setCalculationTime(BenchmarkManager.this.runTime);
            if (this.image != null) {
                System.out.println("Number of pixels rendered: " + this.image.getCount());
            }
        }
    }

    protected class StartCallback
    implements Runnable {
        protected StartCallback() {
        }

        public void run() {
            BenchmarkManager.this.startTime = System.nanoTime();
        }
    }
}

