/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mandelbrot.control;

import ch.skybeam.mandelbrot.Mandelbrot;
import ch.skybeam.mandelbrot.model.BenchmarkManager;
import ch.skybeam.mandelbrot.model.BookmarkItem;
import ch.skybeam.mandelbrot.model.BookmarkManager;
import ch.skybeam.mandelbrot.model.MandelbrotCalculator;
import ch.skybeam.mandelbrot.model.Settings;
import ch.skybeam.mandelbrot.model.lock.CountingImage;
import ch.skybeam.mandelbrot.model.lock.LockingImageCAS;
import ch.skybeam.mandelbrot.model.lock.LockingImageCoarse;
import ch.skybeam.mandelbrot.model.lock.LockingImageFine;
import ch.skybeam.mandelbrot.model.lock.NonLockingImage;
import ch.skybeam.mandelbrot.view.MandelbrotGUI;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;

public class Controller {
    public static final String rcsHeader = "$Header: /data/cvs/diplomarbeit/JTSFraktal/src/ch/skybeam/mandelbrot/control/Controller.java,v 1.21 2006/11/12 12:03:30 rme Exp $";
    public static final String rcsName = "$Name:  $";
    public static final String rcsRevision = "$Revision: 1.21 $";
    private static final Controller controller = new Controller();
    private static final String DEFAULT_SETTINGSFILE = "settings.xml";
    private static final String DEFAULT_BOOKMARKSFILE = "bookmarks.xml";
    private Settings settings = new Settings();
    private BenchmarkManager manager;
    private BookmarkManager bookmarkManager = new BookmarkManager();
    private MandelbrotGUI gui;
    private volatile int imageWidth = 1;
    private volatile int imageHeight = 1;

    public static synchronized Controller getInstance() {
        return controller;
    }

    private Controller() {
    }

    public void init() {
        if (!this.isApplet()) {
            File file = new File(DEFAULT_SETTINGSFILE);
            if (file.exists()) {
                this.settings.loadConfiguration(file);
            }
            if ((file = new File(DEFAULT_BOOKMARKSFILE)).exists()) {
                this.bookmarkManager.loadConfiguration(file);
            }
        }
        this.manager = new BenchmarkManager(1);
        this.settings.setJOMPSupport(this.checkJOMPSupport());
        this.setNumWorkers(this.settings.getNumWorkers(), false);
        this.gui = new MandelbrotGUI();
        this.updateBookmarks();
    }

    public void quit() {
        if (!this.isApplet()) {
            this.settings.saveConfiguration(new File(DEFAULT_SETTINGSFILE));
            this.bookmarkManager.saveConfiguration(new File(DEFAULT_BOOKMARKSFILE));
            if (this.manager != null) {
                this.manager.shutdownWorkers();
            }
            System.out.println("Exiting.");
            System.exit(0);
        } else {
            this.setVisibility(false);
        }
    }

    public void quitApplet() {
        if (this.manager != null) {
            this.manager.shutdownWorkers();
        }
        this.quit();
    }

    public void setImage(int n, int n2) {
        if (this.imageWidth > 0 && this.imageHeight > 0) {
            this.imageWidth = n;
            this.imageHeight = n2;
            if (this.settings.isAutoRestart()) {
                this.restartCalculation();
            }
        }
    }

    public void restartCalculation() {
        if (this.manager != null) {
            CountingImage countingImage = new NonLockingImage(this.imageWidth, this.imageHeight, 1);
            switch (this.settings.getLockType()) {
                case 1: {
                    System.out.println("Using coarse grained lock");
                    countingImage = new LockingImageCoarse(this.imageWidth, this.imageHeight, 1);
                    break;
                }
                case 2: {
                    System.out.println("Using fine grained lock");
                    countingImage = new LockingImageFine(this.imageWidth, this.imageHeight, 1);
                    break;
                }
                case 3: {
                    System.out.println("Using CAS \"Locking\"");
                    countingImage = new LockingImageCAS(this.imageWidth, this.imageHeight, 1);
                }
            }
            for (int i = 0; i < countingImage.getHeight(); ++i) {
                for (int j = 0; j < countingImage.getWidth(); ++j) {
                    countingImage.setRGB(j, i, -1);
                }
            }
            this.manager.setJob(countingImage, this.settings.getMandelbrotX(), this.settings.getMandelbrotY(), this.settings.getMandelbrotWidth(), this.settings.getMaxIterations());
        }
    }

    public void drawColorMap() {
        this.interruptCalculation();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        BufferedImage bufferedImage = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        for (int i = 0; i < this.imageWidth; ++i) {
            int n = (int)((double)(MandelbrotCalculator.colors.length / this.imageWidth) * (double)i);
            for (int j = 0; j < this.imageHeight; ++j) {
                bufferedImage.setRGB(i, j, 1, 1, (int[])MandelbrotCalculator.colors[n], 0, 1);
            }
        }
        this.gui.drawImage(bufferedImage);
    }

    public void drawImage(BufferedImage bufferedImage) {
        this.gui.drawImage(bufferedImage);
    }

    public void setZoom(Rectangle rectangle) {
        double d = (double)this.imageHeight / (double)this.imageWidth;
        double d2 = this.settings.getMandelbrotWidth() * d;
        this.settings.setMandelbrotX(this.settings.getMandelbrotX() + this.settings.getMandelbrotWidth() / (double)this.imageWidth * (double)rectangle.x);
        this.settings.setMandelbrotY(this.settings.getMandelbrotY() + d2 / (double)this.imageHeight * (double)rectangle.y);
        this.settings.setMandelbrotWidth(this.settings.getMandelbrotWidth() / (double)this.imageWidth * (double)rectangle.width);
        this.restartCalculation();
    }

    public BenchmarkManager getManager() {
        return this.manager;
    }

    public double getMandelbrotWidth() {
        return this.settings.getMandelbrotWidth();
    }

    public double getMandelbrotX() {
        return this.settings.getMandelbrotX();
    }

    public void setMandelbrotCoordinates(double d, double d2, double d3, boolean bl) {
        this.settings.setMandelbrotX(d);
        this.settings.setMandelbrotY(d2);
        this.settings.setMandelbrotWidth(d3);
        if (bl && this.settings.isAutoRestart()) {
            this.restartCalculation();
        }
    }

    public double getMandelbrotY() {
        return this.settings.getMandelbrotY();
    }

    public int getNumWorkers() {
        return this.settings.getNumWorkers();
    }

    public boolean isAutoRestart() {
        return this.settings.isAutoRestart();
    }

    public void setAutoRestart(boolean bl) {
        this.settings.setAutoRestart(bl);
    }

    public void setNumWorkers(int n, boolean bl) {
        if (this.settings.getImplType() == 1) {
            if (n >= 1) {
                if (this.manager != null) {
                    this.manager.setWorkerNumber(1);
                }
                this.setJOMPWorkers(n);
            } else if (this.manager != null) {
                this.settings.setNumWorkers(this.manager.setWorkerNumber(n));
            }
        } else if (this.manager != null) {
            this.settings.setNumWorkers(this.manager.setWorkerNumber(n));
        }
        if (bl && this.settings.isAutoRestart()) {
            this.restartCalculation();
        }
    }

    private void setJOMPWorkers(int n) {
        boolean bl = false;
        int n2 = 0;
        while (!bl && n2 < 10) {
            try {
                ++n2;
                System.out.println("setting worker number");
                Class<?> clazz = Class.forName("jomp.runtime.OMP");
                Class[] classArray = new Class[]{Integer.TYPE};
                Method method = clazz.getMethod("setNumThreads", classArray);
                method.invoke(clazz, new Integer(n));
                this.settings.setNumWorkers(n);
                bl = true;
            }
            catch (Exception exception) {
                System.err.println("Error. Cannot set JOMP worker number");
                exception.printStackTrace();
            }
        }
    }

    public int getMaxIterations() {
        return this.settings.getMaxIterations();
    }

    public void setMaxIterations(int n, boolean bl) {
        this.settings.setMaxIterations(n);
        if (bl && this.settings.isAutoRestart()) {
            this.restartCalculation();
        }
    }

    public void interruptCalculation() {
        if (this.manager != null) {
            this.manager.resetWorkers();
        }
    }

    public int getLockType() {
        return this.settings.getLockType();
    }

    public void setLockType(int n) {
        this.settings.setLockType(n);
    }

    public void addBookmark(String string) {
        this.bookmarkManager.addItem(new BookmarkItem(string, this.settings.getMandelbrotX(), this.settings.getMandelbrotY(), this.settings.getMandelbrotWidth(), this.settings.getMaxIterations()));
        this.updateBookmarks();
    }

    public void removeBookmark(BookmarkItem bookmarkItem) {
        this.bookmarkManager.removeItem(bookmarkItem);
        this.updateBookmarks();
    }

    public void clearBookmarks() {
        this.bookmarkManager.clearItems();
        this.updateBookmarks();
    }

    private void updateBookmarks() {
        this.gui.updateBookmarks(this.bookmarkManager.getItems());
    }

    public void saveBookmarks(File file) {
        this.bookmarkManager.saveConfiguration(file);
    }

    public void loadBookmarks(File file) {
        this.bookmarkManager.loadConfiguration(file);
        this.updateBookmarks();
    }

    public void setImplType(int n, boolean bl) {
        this.settings.setImplType(n);
        if (n == 1) {
            this.setNumWorkers(this.settings.getNumWorkers(), false);
        }
        if (bl && this.settings.isAutoRestart()) {
            this.restartCalculation();
        }
    }

    public int getImplType() {
        return this.settings.getImplType();
    }

    public boolean isJOMPSupport() {
        return this.settings.isJOMPSupport();
    }

    public void setJOMPSupport(boolean bl) {
        this.settings.setJOMPSupport(bl);
    }

    public boolean isApplet() {
        return Mandelbrot.isApplet();
    }

    public void setVisibility(boolean bl) {
        this.gui.setVisible(bl);
    }

    public boolean isVisible() {
        return this.gui.isVisible();
    }

    public void setCalculationTime(long l) {
        this.gui.setCalculationTime(l);
    }

    private boolean checkJOMPSupport() {
        boolean bl = false;
        try {
            this.getClass().getClassLoader().loadClass("jomp.runtime.OMP");
            this.getClass().getClassLoader().loadClass("ch.skybeam.mandelbrot.model.MandelbrotCalculatorJOMP");
            System.out.println("JOMP support enabled");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("JOMP Support disabled. Either the JOMP plug-in or the JOMP classes could not be found");
        }
        return bl;
    }
}

