/*
 * Decompiled with CFR 0.152.
 */
package ch.skybeam.mandelbrot.model;

import ch.skybeam.mandelbrot.control.Controller;
import ch.skybeam.mandelbrot.model.MandelbrotCalculator;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import jomp.runtime.BusyTask;
import jomp.runtime.LoopData;
import jomp.runtime.OMP;

public class MandelbrotCalculatorJOMP
extends MandelbrotCalculator {
    private double mandelbrotX = 0.0;
    private double mandelbrotY = 0.0;
    private double mandelbrotWidth = 0.0;
    private Rectangle renderArea;

    public MandelbrotCalculatorJOMP() {
        super(new BufferedImage(1, 1, 1), new Rectangle(1, 1), 0.0, 0.0, 1.0, 100);
    }

    public MandelbrotCalculatorJOMP(BufferedImage bufferedImage, Rectangle rectangle, double d, double d2, double d3, int n) {
        super(bufferedImage, rectangle, d, d2, d3, n);
        this.mandelbrotX = d;
        this.mandelbrotY = d2;
        this.mandelbrotWidth = d3;
        this.renderArea = rectangle;
    }

    public void run() {
        double d = this.mandelbrotCoordinates.x + this.mandelbrotCoordinates.width / (double)this.image.getWidth() * (double)(this.imageRenderArea.x + 1);
        double d2 = this.mandelbrotCoordinates.y + this.mandelbrotCoordinates.height / (double)this.image.getHeight() * (double)(this.imageRenderArea.y + 1);
        double d3 = this.mandelbrotCoordinates.width / (double)this.image.getWidth() * (double)this.imageRenderArea.width;
        double d4 = this.mandelbrotCoordinates.height / (double)this.image.getHeight() * (double)this.imageRenderArea.height;
        double d5 = d3 / (double)this.imageRenderArea.width;
        double d6 = d4 / (double)this.imageRenderArea.height;
        double d7 = d;
        double d8 = d2;
        boolean bl = false;
        double d9 = (double)(numColors - 1) / (double)this.maxIteration;
        System.out.println("Calculating...");
        System.out.println("X: " + (this.imageRenderArea.x + 1) + " to " + (this.imageRenderArea.x + this.imageRenderArea.width));
        System.out.println("Y: " + (this.imageRenderArea.y + 1) + " to " + (this.imageRenderArea.y + this.imageRenderArea.height));
        __omp_Class0 __omp_Class02 = new __omp_Class0();
        __omp_Class02.distanceX = d5;
        __omp_Class02.distanceY = d6;
        __omp_Class02.mandelbrotRenderX = d;
        __omp_Class02.mandelbrotRenderY = d2;
        __omp_Class02.colorspacing = d9;
        __omp_Class02.mandelbrotRenderHeight = d4;
        __omp_Class02.mandelbrotRenderWidth = d3;
        __omp_Class02.maxIteration = this.maxIteration;
        __omp_Class02.mandelbrotWidth = this.mandelbrotWidth;
        __omp_Class02.mandelbrotY = this.mandelbrotY;
        __omp_Class02.mandelbrotX = this.mandelbrotX;
        __omp_Class02.renderArea = this.renderArea;
        __omp_Class02.image = this.image;
        try {
            OMP.doParallel((BusyTask)__omp_Class02);
        }
        catch (Throwable throwable) {
            System.err.println("OMP Warning: Illegal thread exception ignored!");
            System.err.println(throwable);
        }
        d5 = __omp_Class02.distanceX;
        d6 = __omp_Class02.distanceY;
        d = __omp_Class02.mandelbrotRenderX;
        d2 = __omp_Class02.mandelbrotRenderY;
        d9 = __omp_Class02.colorspacing;
        d4 = __omp_Class02.mandelbrotRenderHeight;
        d3 = __omp_Class02.mandelbrotRenderWidth;
        this.maxIteration = __omp_Class02.maxIteration;
        this.mandelbrotWidth = __omp_Class02.mandelbrotWidth;
        this.mandelbrotY = __omp_Class02.mandelbrotY;
        this.mandelbrotX = __omp_Class02.mandelbrotX;
        this.renderArea = __omp_Class02.renderArea;
        this.image = __omp_Class02.image;
        Controller.getInstance().drawImage(this.image);
    }

    private class __omp_Class0
    extends BusyTask {
        double distanceX;
        double distanceY;
        double mandelbrotRenderX;
        double mandelbrotRenderY;
        double colorspacing;
        double mandelbrotRenderHeight;
        double mandelbrotRenderWidth;
        int maxIteration;
        double mandelbrotWidth;
        double mandelbrotY;
        double mandelbrotX;
        Rectangle renderArea;
        BufferedImage image;

        private __omp_Class0() {
        }

        public void go(int n) throws Throwable {
            boolean bl = false;
            LoopData loopData = new LoopData();
            LoopData loopData2 = new LoopData();
            loopData.start = MandelbrotCalculatorJOMP.this.imageRenderArea.x;
            loopData.stop = MandelbrotCalculatorJOMP.this.imageRenderArea.x + MandelbrotCalculatorJOMP.this.imageRenderArea.width;
            loopData.step = 1L;
            OMP.setChunkStatic((LoopData)loopData);
            block0: while (!loopData2.isLast && OMP.getLoopStatic((int)n, (LoopData)loopData, (LoopData)loopData2)) {
                while (true) {
                    if (loopData.step > 0L) {
                        if (loopData2.stop > loopData.stop) {
                            loopData2.stop = loopData.stop;
                        }
                        if (loopData2.start >= loopData.stop) {
                            continue block0;
                        }
                    } else {
                        if (loopData2.stop < loopData.stop) {
                            loopData2.stop = loopData.stop;
                        }
                        if (loopData2.start > loopData.stop) continue block0;
                    }
                    int n2 = (int)loopData2.start;
                    while ((long)n2 < loopData2.stop) {
                        double d = this.mandelbrotRenderX + this.distanceX * (double)(n2 - MandelbrotCalculatorJOMP.this.imageRenderArea.x + 1);
                        double d2 = this.mandelbrotRenderY;
                        for (int i = MandelbrotCalculatorJOMP.this.imageRenderArea.y; i < MandelbrotCalculatorJOMP.this.imageRenderArea.y + MandelbrotCalculatorJOMP.this.imageRenderArea.height && !MandelbrotCalculatorJOMP.this.interruptCalculation.get(); ++i) {
                            d2 = this.mandelbrotRenderY + (double)(i - MandelbrotCalculatorJOMP.this.imageRenderArea.y) * this.distanceY;
                            int n3 = MandelbrotCalculatorJOMP.this.mandelbrotTest(d, d2);
                            if (n3 != -1) {
                                int n4 = (int)(this.colorspacing * (double)n3);
                                this.image.setRGB(n2, i, 1, 1, (int[])MandelbrotCalculator.colors[n4], 0, 1);
                            } else {
                                this.image.setRGB(n2, i, 1, 1, MandelbrotCalculator.colorNotPart, 0, 1);
                            }
                            if (n2 % 50 != 0) continue;
                            Controller.getInstance().drawImage(this.image);
                        }
                        if ((long)n2 == loopData.stop - 1L) {
                            bl = true;
                        }
                        n2 = (int)((long)n2 + loopData2.step);
                    }
                    if (loopData2.startStep == 0L) continue block0;
                    loopData2.start += loopData2.startStep;
                    loopData2.stop += loopData2.startStep;
                }
            }
            OMP.doBarrier((int)n);
            if (bl) {
                // empty if block
            }
            if (bl) {
                // empty if block
            }
            if (OMP.getThreadNum((int)n) == 0) {
                // empty if block
            }
            if (OMP.getThreadNum((int)n) == 0) {
                // empty if block
            }
        }
    }
}

