/*
 * Decompiled with CFR 0.152.
 */
package jomp.runtime;

import jomp.runtime.LoopData;

class Ticketer {
    private long ticket = 0L;
    private long add;
    private boolean init = false;
    private Ticketer next = null;
    private boolean isLoopSetup = false;

    Ticketer() {
    }

    synchronized long issue() {
        return this.ticket++;
    }

    synchronized Ticketer reset() {
        if (this.next == null) {
            this.next = new Ticketer();
        }
        return this.next;
    }

    synchronized void initDyn(LoopData loopData) {
        if (!this.init) {
            this.ticket = loopData.start;
            this.add = loopData.chunkSize * loopData.step;
            this.init = true;
        }
    }

    synchronized void issueDynamic(LoopData loopData) {
        loopData.start = this.ticket;
        this.ticket += this.add;
        loopData.stop = this.ticket;
    }

    synchronized boolean issueGuided(LoopData loopData, LoopData loopData2, int n) {
        if (!this.isLoopSetup) {
            this.ticket = loopData.start;
            this.isLoopSetup = true;
        }
        loopData2.start = this.ticket;
        long l = (loopData.stop - this.ticket) / loopData.step;
        long l2 = l / (long)(2 * n);
        if (l2 < loopData.chunkSize) {
            l2 = loopData.chunkSize;
        }
        this.ticket = loopData2.stop = this.ticket + l2 * loopData.step;
        if (loopData.step > 0L) {
            if (loopData2.start >= loopData.stop) {
                return false;
            }
            if (loopData2.stop >= loopData.stop) {
                loopData2.stop = loopData.stop;
                loopData2.isLast = true;
            }
        } else {
            if (loopData2.start <= loopData.stop) {
                return false;
            }
            if (loopData2.stop <= loopData.stop) {
                loopData2.stop = loopData.stop;
                loopData2.isLast = true;
            }
        }
        loopData2.step = loopData.step;
        return true;
    }
}

