/*
 * Decompiled with CFR 0.152.
 */
package jomp.runtime;

class Reducer {
    private volatile boolean[] isDone;
    private volatile long[] longValue;
    private volatile double[] doubleValue;
    private volatile boolean[] booleanValue;
    private int maxBusyIter = 1;
    private int numThreads;

    Reducer(int n) {
        this.numThreads = n;
        this.isDone = new boolean[this.numThreads];
        this.longValue = new long[this.numThreads];
        this.doubleValue = new double[this.numThreads];
        this.booleanValue = new boolean[this.numThreads];
        int n2 = 0;
        while (n2 < n) {
            this.isDone[n2] = false;
            ++n2;
        }
    }

    long doPlusReduce(int n, long l) {
        int n2;
        int n3 = 3;
        boolean bl = !this.isDone[n];
        while ((n & n3) == 0 && n3 < this.numThreads << 2) {
            int n4 = n3 + 1 >> 2;
            int n5 = 1;
            while (n5 <= 3 && n + n5 * n4 < this.numThreads) {
                n2 = this.maxBusyIter;
                while (this.isDone[n + n5 * n4] != bl) {
                    if (--n2 != 0) continue;
                    Thread.yield();
                    n2 = this.maxBusyIter;
                }
                l += this.longValue[n + n5 * n4];
                ++n5;
            }
            n3 = (n3 << 2) + 3;
        }
        this.longValue[n] = l;
        this.isDone[n] = bl;
        n2 = this.maxBusyIter;
        while (this.isDone[0] != bl) {
            if (--n2 != 0) continue;
            Thread.yield();
            n2 = this.maxBusyIter;
        }
        return this.longValue[0];
    }

    double doPlusReduce(int n, double d) {
        int n2;
        int n3 = 3;
        boolean bl = !this.isDone[n];
        while ((n & n3) == 0 && n3 < this.numThreads << 2) {
            int n4 = n3 + 1 >> 2;
            int n5 = 1;
            while (n5 <= 3 && n + n5 * n4 < this.numThreads) {
                n2 = this.maxBusyIter;
                while (this.isDone[n + n5 * n4] != bl) {
                    if (--n2 != 0) continue;
                    Thread.yield();
                    n2 = this.maxBusyIter;
                }
                d += this.doubleValue[n + n5 * n4];
                ++n5;
            }
            n3 = (n3 << 2) + 3;
        }
        this.doubleValue[n] = d;
        this.isDone[n] = bl;
        n2 = this.maxBusyIter;
        while (this.isDone[0] != bl) {
            if (--n2 != 0) continue;
            Thread.yield();
            n2 = this.maxBusyIter;
        }
        return this.doubleValue[0];
    }

    long doMultReduce(int n, long l) {
        int n2;
        int n3 = 3;
        boolean bl = !this.isDone[n];
        while ((n & n3) == 0 && n3 < this.numThreads << 2) {
            int n4 = n3 + 1 >> 2;
            int n5 = 1;
            while (n5 <= 3 && n + n5 * n4 < this.numThreads) {
                n2 = this.maxBusyIter;
                while (this.isDone[n + n5 * n4] != bl) {
                    if (--n2 != 0) continue;
                    Thread.yield();
                    n2 = this.maxBusyIter;
                }
                l *= this.longValue[n + n5 * n4];
                ++n5;
            }
            n3 = (n3 << 2) + 3;
        }
        this.longValue[n] = l;
        this.isDone[n] = bl;
        n2 = this.maxBusyIter;
        while (this.isDone[0] != bl) {
            if (--n2 != 0) continue;
            Thread.yield();
            n2 = this.maxBusyIter;
        }
        return this.longValue[0];
    }

    double doMultReduce(int n, double d) {
        int n2;
        int n3 = 3;
        boolean bl = !this.isDone[n];
        while ((n & n3) == 0 && n3 < this.numThreads << 2) {
            int n4 = n3 + 1 >> 2;
            int n5 = 1;
            while (n5 <= 3 && n + n5 * n4 < this.numThreads) {
                n2 = this.maxBusyIter;
                while (this.isDone[n + n5 * n4] != bl) {
                    if (--n2 != 0) continue;
                    Thread.yield();
                    n2 = this.maxBusyIter;
                }
                d *= this.doubleValue[n + n5 * n4];
                ++n5;
            }
            n3 = (n3 << 2) + 3;
        }
        this.doubleValue[n] = d;
        this.isDone[n] = bl;
        n2 = this.maxBusyIter;
        while (this.isDone[0] != bl) {
            if (--n2 != 0) continue;
            Thread.yield();
            n2 = this.maxBusyIter;
        }
        return this.doubleValue[0];
    }

    boolean doAndReduce(int n, boolean bl) {
        int n2;
        int n3 = 3;
        boolean bl2 = !this.isDone[n];
        while ((n & n3) == 0 && n3 < this.numThreads << 2) {
            int n4 = n3 + 1 >> 2;
            int n5 = 1;
            while (n5 <= 3 && n + n5 * n4 < this.numThreads) {
                n2 = this.maxBusyIter;
                while (this.isDone[n + n5 * n4] != bl2) {
                    if (--n2 != 0) continue;
                    Thread.yield();
                    n2 = this.maxBusyIter;
                }
                bl = bl && this.booleanValue[n + n5 * n4];
                ++n5;
            }
            n3 = (n3 << 2) + 3;
        }
        this.booleanValue[n] = bl;
        this.isDone[n] = bl2;
        n2 = this.maxBusyIter;
        while (this.isDone[0] != bl2) {
            if (--n2 != 0) continue;
            Thread.yield();
            n2 = this.maxBusyIter;
        }
        return this.booleanValue[0];
    }

    boolean doOrReduce(int n, boolean bl) {
        int n2;
        int n3 = 3;
        boolean bl2 = !this.isDone[n];
        while ((n & n3) == 0 && n3 < this.numThreads << 2) {
            int n4 = n3 + 1 >> 2;
            int n5 = 1;
            while (n5 <= 3 && n + n5 * n4 < this.numThreads) {
                n2 = this.maxBusyIter;
                while (this.isDone[n + n5 * n4] != bl2) {
                    if (--n2 != 0) continue;
                    Thread.yield();
                    n2 = this.maxBusyIter;
                }
                bl = bl || this.booleanValue[n + n5 * n4];
                ++n5;
            }
            n3 = (n3 << 2) + 3;
        }
        this.booleanValue[n] = bl;
        this.isDone[n] = bl2;
        n2 = this.maxBusyIter;
        while (this.isDone[0] != bl2) {
            if (--n2 != 0) continue;
            Thread.yield();
            n2 = this.maxBusyIter;
        }
        return this.booleanValue[0];
    }

    long doBitOrReduce(int n, long l) {
        int n2;
        int n3 = 3;
        boolean bl = !this.isDone[n];
        while ((n & n3) == 0 && n3 < this.numThreads << 2) {
            int n4 = n3 + 1 >> 2;
            int n5 = 1;
            while (n5 <= 3 && n + n5 * n4 < this.numThreads) {
                n2 = this.maxBusyIter;
                while (this.isDone[n + n5 * n4] != bl) {
                    if (--n2 != 0) continue;
                    Thread.yield();
                    n2 = this.maxBusyIter;
                }
                l |= this.longValue[n + n5 * n4];
                ++n5;
            }
            n3 = (n3 << 2) + 3;
        }
        this.longValue[n] = l;
        this.isDone[n] = bl;
        n2 = this.maxBusyIter;
        while (this.isDone[0] != bl) {
            if (--n2 != 0) continue;
            Thread.yield();
            n2 = this.maxBusyIter;
        }
        return this.longValue[0];
    }

    long doBitXorReduce(int n, long l) {
        int n2;
        int n3 = 3;
        boolean bl = !this.isDone[n];
        while ((n & n3) == 0 && n3 < this.numThreads << 2) {
            int n4 = n3 + 1 >> 2;
            int n5 = 1;
            while (n5 <= 3 && n + n5 * n4 < this.numThreads) {
                n2 = this.maxBusyIter;
                while (this.isDone[n + n5 * n4] != bl) {
                    if (--n2 != 0) continue;
                    Thread.yield();
                    n2 = this.maxBusyIter;
                }
                l ^= this.longValue[n + n5 * n4];
                ++n5;
            }
            n3 = (n3 << 2) + 3;
        }
        this.longValue[n] = l;
        this.isDone[n] = bl;
        n2 = this.maxBusyIter;
        while (this.isDone[0] != bl) {
            if (--n2 != 0) continue;
            Thread.yield();
            n2 = this.maxBusyIter;
        }
        return this.longValue[0];
    }

    long doBitAndReduce(int n, long l) {
        int n2;
        int n3 = 3;
        boolean bl = !this.isDone[n];
        while ((n & n3) == 0 && n3 < this.numThreads << 2) {
            int n4 = n3 + 1 >> 2;
            int n5 = 1;
            while (n5 <= 3 && n + n5 * n4 < this.numThreads) {
                n2 = this.maxBusyIter;
                while (this.isDone[n + n5 * n4] != bl) {
                    if (--n2 != 0) continue;
                    Thread.yield();
                    n2 = this.maxBusyIter;
                }
                l &= this.longValue[n + n5 * n4];
                ++n5;
            }
            n3 = (n3 << 2) + 3;
        }
        this.longValue[n] = l;
        this.isDone[n] = bl;
        n2 = this.maxBusyIter;
        while (this.isDone[0] != bl) {
            if (--n2 != 0) continue;
            Thread.yield();
            n2 = this.maxBusyIter;
        }
        return this.longValue[0];
    }
}

